package com.bcxin.api.interfaces.tenants.responses;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.PersonStatus;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.utils.CdnUtils;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import javax.persistence.Column;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;

@Getter
public class EmployeeDetailGetResponse extends ResponseAbstract {
    @ApiModelProperty("Id")
    private final String id;
    @ApiModelProperty("部门Id")
    private final String departId;
    @ApiModelProperty("部门名称")
    private final String departName;
    @ApiModelProperty("上级Id")
    private final String superiorId;
    @ApiModelProperty("上级名称")
    private final String superiorName;
    @ApiModelProperty("入职时间")
    private final String hiredDate;
    @ApiModelProperty("转正时间")
    private final String positiveDate;
    @ApiModelProperty("职位")
    private final String position;
    @ApiModelProperty("职业类型")
    private final OccupationType occupationType;
    /**
     * 是否投保
     */
    private final TrueFalseStatus isInsure;

    /**
     * 职员详细信息
     */
    private final UserDetailGetResponse userInfo;

    /**
     * 在职天数
     */
    private final long workDays;

    private final List<DepartResponse> departs;

    /**
     * 面谈记录
     */
    @ApiModelProperty(value = "面谈记录")
    private String interview;

    /**
     * 员工状态（选填，单选：全职/兼职/试用/实习）
     */
    @ApiModelProperty(value = "员工状态")
    private final PersonStatus personStatus;

    /**
     * 试用期 数字
     */
    @ApiModelProperty(value = "试用期")
    private final String probation;


    /**
     * 原定转正日期 年月日
     */
    @ApiModelProperty(value = "原定转正日期")
    private final Date planPositiveDate;

    /**
     * 薪资
     */
    @ApiModelProperty(value = "薪资")
    private String salary;

    public EmployeeDetailGetResponse(String id,
                                     String departId,
                                     String departName,
                                     String superiorId,
                                     String superiorName,
                                     Date hiredDate, Date positiveDate,
                                     String position,
                                     OccupationType occupationType,
                                     TrueFalseStatus isInsure,
                                     UserDetailGetResponse userInfo,
                                     List<DepartResponse> departs,
                                     String interview,
                                     PersonStatus personStatus,
                                     String probation,
                                     Date planPositiveDate,
                                     String salary) {
        this.id = id;
        this.superiorId = superiorId;
        this.superiorName = superiorName;
        this.isInsure = isInsure;
        this.departs = departs;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (hiredDate != null) {
            this.hiredDate = simpleDateFormat.format(hiredDate);
            this.workDays = DateUtil.between(hiredDate, Timestamp.from(Instant.now()), DateUnit.DAY);
        } else {
            this.hiredDate = null;
            this.workDays = 0;
        }

        if (positiveDate != null) {
            this.positiveDate = simpleDateFormat.format(positiveDate);
        } else {
            this.positiveDate = null;
        }

        this.position = position;
        this.occupationType = occupationType;
        this.userInfo = userInfo;
        this.departId = departId;
        this.departName = departName;
        this.interview = CdnUtils.convert(interview);
        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.salary = salary;
    }

    public static EmployeeDetailGetResponse create(String id,
                                                   String departId,
                                                   String departName,
                                                   String superiorId,
                                                   String superiorName,
                                                   Date hiredDate, Date positiveDate,
                                                   String position,
                                                   OccupationType occupationType,
                                                   TrueFalseStatus isInsure,
                                                   UserDetailGetResponse userInfo,
                                                   List<DepartResponse> departs,
                                                   String interview,
                                                   PersonStatus personStatus,
                                                   String probation,
                                                   Date planPositiveDate,
                                                   String salary) {
        return new EmployeeDetailGetResponse(id,
                departId,
                departName,
                superiorId, superiorName, hiredDate, positiveDate, position, occupationType, isInsure, userInfo,departs,
                interview,
                personStatus,
                probation,
                planPositiveDate,
                salary);
    }
}
