package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class CurrentCredentialResponse implements Serializable {
    /**
     * 证件姓名
     */
    private String name;

    private String credentialType;

    private String number;

    /**
     * 发证机关
     */
    private String orgName;

    /**
     * 发证日期
     */
    private Date cerDate;

    private List<String> comIds;

    public CurrentCredentialResponse(){}
    public CurrentCredentialResponse(String name,
                                     String credentialType,
                                     String number,
                                     String orgName,
                                     Date cerDate){

        this.name = name;
        this.credentialType = credentialType;
        this.number = number;
        this.orgName = orgName;
        this.cerDate = cerDate;
    }

    public static CurrentCredentialResponse create(String name,
                                                   String credentialType,
                                                   String number,
                                                   String orgName,
                                                   Date cerDate){
        return new CurrentCredentialResponse( name,
                 credentialType,
                 number,
                 orgName,
                 cerDate);

    }
}
