package com.bcxin.api.interfaces.tenants.requests.organizations;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

/**
 * @author linqinglin
 * @date 2021/12/10 0010 19:31
 */
@Getter
public class OrganizationRequest extends RequestAbstract {

    private String id;

    private String name;

    private String unifySocialCreditCode;

    public OrganizationRequest(String id,String name,String unifySocialCreditCode){
        this.id = id;
        this.name = name;
        this.unifySocialCreditCode = unifySocialCreditCode;
    }

    public static OrganizationRequest create(String id, String name, String unifySocialCreditCode) {
        return new OrganizationRequest(id,name,unifySocialCreditCode);
    }


    public void validate() {
        if(StrUtil.isEmpty(this.name) && StrUtil.isEmpty(this.unifySocialCreditCode)){
            throw new BadTenantException("请输入组织名称或者社会信用代码！");
        }
    }
}
