package com.bcxin.api.interfaces.tenants.requests.inviteAttendSite;

import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.sql.Timestamp;

@Data
public class InviteAttendSiteRequest extends RequestAbstract {


    /**
     * 驻勤点Id
     */
    @NotEmpty
    private String attendSiteId;

    /**
     * 驻勤点名称
     */
    @NotEmpty
    private String attendSiteName;

    /**
     * 入职部门
     */
    @NotEmpty
    private String departId;

    /**
     * 职业类型
     */
    private OccupationType occupationType = OccupationType.SecurityGuard;

    /**
     * 链接有效截止日期
     */
    @NotNull
    private Timestamp endTime;

}
