package com.bcxin.api.interfaces.tenants.requests.externalGroups;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

@ApiModel("创建分组信息")
@Getter
public class ExternalGroupRequest extends RequestAbstract {

    @ApiModelProperty("名称")
    private final String name;

    @ApiModelProperty("序号")
    private final int displayOrder;

    @ApiModelProperty("负责人")
    private final String principalId;

    @ApiModelProperty("父节点")
    private final String parentId;

    public ExternalGroupRequest(String name, int displayOrder,String principalId, String parentId) {
        this.name = name;
        this.principalId = principalId;
        this.displayOrder = displayOrder;
        this.parentId = parentId;
    }
}
