package com.bcxin.api.interfaces.tenants;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.commons.CommonImportResponse;
import com.bcxin.api.interfaces.tenants.criterias.ContractCriteria;
import com.bcxin.api.interfaces.tenants.requests.contracts.BatchDeleteContractRequest;
import com.bcxin.api.interfaces.tenants.requests.contracts.BatchImportContractRequest;
import com.bcxin.api.interfaces.tenants.requests.contracts.CreateContractRequest;
import com.bcxin.api.interfaces.tenants.requests.contracts.UpdateContractRequest;
import com.bcxin.api.interfaces.tenants.responses.ContractGetResponse;
import com.bcxin.api.interfaces.tenants.responses.ContractReportResponse;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;

@Component
public interface ContractRpcProvider {
    void create(String organizationId, CreateContractRequest request);

    void update(String organizationId, String id, UpdateContractRequest request);

    void delete(String organizationId, String id);

    void batchDelete(String organizationId, BatchDeleteContractRequest request);

    Pageable<ContractGetResponse> find(String organizationId, ContractCriteria criteria);

    CommonImportResponse batchImport(String organizationId, String path, Collection<BatchImportContractRequest> requests);

    String exportExcel(String organizationId, ContractCriteria criteria);

    ContractReportResponse findReport(String organizationId, ContractCriteria criteria);

    String  getOrganIdAndId(String organizationId, String id);
}