package com.bcxin.api.interfaces.rbacs.custom.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("功能授权查询对象")
@Data
public class RbacPermitSearchRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业id", hidden = true)
    private String organizationId;

    @ApiModelProperty(value = "职员id（查询职员权限的时候传）")
    private String employeeId;

    @ApiModelProperty(value = "查询类型：1单独，2所有(查询职员权限的时候传)")
    private Integer searchType;

    @ApiModelProperty(value = "角色id(查询角色权限的时候传)")
    private Long roleId;

}
