package com.bcxin.api.interfaces.rbacs.custom;

import com.bcxin.api.interfaces.rbacs.custom.request.RbacPermitAuthRequest;
import com.bcxin.api.interfaces.rbacs.custom.request.RbacPermitSearchRequest;
import com.bcxin.api.interfaces.rbacs.custom.response.RbacPermitAppResponse;
import com.bcxin.api.interfaces.rbacs.custom.response.RbacPermitAuthResponse;
import com.bcxin.api.interfaces.rbacs.custom.response.RbacPermitOptionResponse;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface RbacPermitManagerProvider {

    /**
     * description：查询企业授权的app列表
     * author：linchunpeng
     * date：2024/2/3
     */
    List<RbacPermitAppResponse> findOrgAppList(String organizationId);

    /**
     * description：查询应用的操作项列表
     * author：linchunpeng
     * date：2024/2/3
     */
    List<RbacPermitOptionResponse> findAppOptionList(Long appId);

    /**
     * description：查询组织授权的应用和操作项，如果有传职员id或角色id，则返回是否授权
     * author：linchunpeng
     * date：2024/3/5
     */
    List<RbacPermitAppResponse> findPermitList(RbacPermitSearchRequest request);

    /**
     * description：角色/职员，功能授权
     * author：linchunpeng
     * date：2024/2/4
     */
    void authPermitOption(RbacPermitAuthRequest request);

    /**
     * description：根据职员id，查询该职员所有的功能授权
     * author：linchunpeng
     * date：2024/2/5
     */
    RbacPermitAuthResponse getEmployeeAuthByEmployeeId(String organizationId, String employeeId);

    /**
     * description：根据角色id，查询该角色所有的功能授权
     * author：linchunpeng
     * date：2024/2/5
     */
    RbacPermitAuthResponse getRoleAuthByRoleId(String organizationId, Long roleId);

    /**
     * description：根据职员id，查询该职员所有的功能授权，包括个人和角色授权
     * author：linchunpeng
     * date：2024/2/5
     */
    RbacPermitAuthResponse getAllAuthByEmployeeId(String organizationId, String employeeId);
}
