package com.bcxin.Infrastructures.models;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.validations.Credential;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class CredentialModel implements Serializable {
    /**
     * 证件类型
     */
    @NotNull
    private CredentialType type;

    /**
     * 证件号码
     */
    @NotEmpty
    private String number;

    public CredentialModel(){}

    public static CredentialModel create(CredentialType type, String number) {
        CredentialModel credential = new CredentialModel();
        credential.setType(type);
        credential.setNumber(number);

        return credential;
    }
}