package com.bcxin.Infrastructures.enums;

/**
 * description: 服务范围-枚举类
 * author: linchunpeng
 * date:  2023-05-05 10:58
 */
public enum ServiceScope implements SwaggerDisplayEnum {

    /**
     * 无
     */
    None{
        @Override
        public String getTypeValue(){return null;}
        @Override
        public String getTypeName(){return "空";}
    },

    /**
     * 门卫
     */
    Guard{
        @Override
        public String getTypeValue(){return "01";}
        @Override
        public String getTypeName(){return "门卫";}
    },

    /**
     * 巡逻
     */
    Patrol{
        @Override
        public String getTypeValue(){return "02";}
        @Override
        public String getTypeName(){return "巡逻";}
    },

    /**
     * 守护
     */
    Protection{
        @Override
        public String getTypeValue(){return "03";}
        @Override
        public String getTypeName(){return "守护";}
    },

    /**
     * 押运
     */
    Escort{
        @Override
        public String getTypeValue(){return "04";}
        @Override
        public String getTypeName(){return "押运";}
    },

    /**
     * 随身护卫
     */
    CarryAroundGuard{
        @Override
        public String getTypeValue(){return "05";}
        @Override
        public String getTypeName(){return "随身护卫";}
    },

    /**
     * 安全检查
     */
    SafetyCheck{
        @Override
        public String getTypeValue(){return "06";}
        @Override
        public String getTypeName(){return "安全检查";}
    },

    /**
     * 区域秩序维护
     */
    MaintenanceOfRegionalOrder{
        @Override
        public String getTypeValue(){return "07";}
        @Override
        public String getTypeName(){return "区域秩序维护";}
    },

    /**
     * 安全风险评估
     */
    SecurityRiskAssessment{
        @Override
        public String getTypeValue(){return "08";}
        @Override
        public String getTypeName(){return "安全风险评估";}
    },

    /**
     * 安全技术防范
     */
    SecurityTechnologyPrevention{
        @Override
        public String getTypeValue(){return "09";}
        @Override
        public String getTypeName(){return "安全技术防范";}
    },

    /**
     * 其他
     */
    Other{
        @Override
        public String getTypeValue(){return "10";}
        @Override
        public String getTypeName(){return "其他";}
    };

    public abstract String getTypeValue();

    public abstract String getTypeName();


    @Override
    public String description() {
        return this.ordinal() + "-" + this.getTypeName();
    }

}
