package com.bcxin.Infrastructures.enums;

/**
 * description: 总分子公司-枚举类
 * author: linchunpeng
 * date:  2023-05-05 10:58
 */
public enum ParentSubsidiary implements SwaggerDisplayEnum {

    /**
     * 空
     */
    None{
        @Override
        public String getTypeName(){return "空";}
    },

    /**
     * 总公司
     */
    Parent{
        @Override
        public String getTypeName(){return "总公司";}
    },

    /**
     * 分公司
     */
    Branch{
        @Override
        public String getTypeName(){return "分公司";}
    },

    /**
     * 子公司
     */
    Subsidiary{
        @Override
        public String getTypeName(){return "子公司";}
    };

    public abstract String getTypeName();


    @Override
    public String description() {
        return this.ordinal() + "-" + this.getTypeName();
    }

}
