package com.bcxin.Infrastructures.enums;

/**
 * 证件类型
 */
public enum CredentialType implements SwaggerDisplayEnum {
    /**
     * 居民身份证/户口簿
     */
    IdCard{
        @Override
        public String getTypeName(){return "居民身份证/户口簿";}

        @Override
        public boolean isIdentityNo() {
            return true;
        }
    },
    /**
     * 香港特区护照/身份证
     */
    IdCardOfXiangGang{
        @Override
        public String getTypeName(){return "香港特区护照/身份证";}

        @Override
        public boolean isIdentityNo() {
            return true;
        }
    },
    /**
     * 澳门特区护照/身份证明
     */
    IdCardOfAoMen{
        @Override
        public String getTypeName(){return "澳门特区护照/身份证明";}

        @Override
        public boolean isIdentityNo() {
            return true;
        }
    },
    /**
     * 台湾居民来往大陆通行证
     */
    IdCardOfTaiwan{
        @Override
        public String getTypeName(){return "台湾居民来往大陆通行证";}

        @Override
        public boolean isIdentityNo() {
            return true;
        }
    },
    /**
     * 外国护照
     */
    Passport{
        @Override
        public String getTypeName(){return "外国护照";}

        @Override
        public boolean isIdentityNo() {
            return true;
        }
    },
    /**
     * 退伍军人证
     */
    Arms{
        @Override
        public String getTypeName(){return "退伍军人证";}

        @Override
        public boolean isIdentityNo() {
            return false;
        }
    },
    /**
     * 警号
     */
    PoliceNo{
        @Override
        public String getTypeName(){return "警号";}

        @Override
        public boolean isIdentityNo() {
            return false;
        }
    },

    QualificationCer{
        @Override
        public String getTypeName(){return "资格证";}

        @Override
        public boolean isIdentityNo() {
            return false;
        }
    },
    /**
     * 等级证
     */
    GradeCer{
        @Override
        public String getTypeName(){return "等级证";}

        @Override
        public boolean isIdentityNo() {
            return false;
        }
    },

    /**
     * 结业证书
     */
    CertificateOfCompletion{
        @Override
        public String getTypeName(){return "结业证";}

        @Override
        public boolean isIdentityNo() {
            return false;
        }
    },

    /**
     * 持枪证
     */
    gun{
        @Override
        public String getTypeName(){return "持枪证";}

        @Override
        public boolean isIdentityNo() {
            return false;
        }
    },


    /**
     * 11 培训结业证
     * @return
     */
    PEIX_CertificateOfCompletion {
        @Override
        public String getTypeName () {
            return "培训结业证";
        }

        @Override
        public boolean isIdentityNo () {
            return false;
        }
    },

    /**
     * 12 志愿者荣誉证书
     */
    Volunteer{
        @Override
        public String getTypeName () {
            return "志愿者荣誉证书";
        }

        @Override
        public boolean isIdentityNo () {
            return false;
        }
    },
    /**
     * 13 志愿者荣誉证书
     */
    IndustryTrainingCertificate{
        @Override
        public String getTypeName () {
            return "行业培训证书";
        }

        @Override
        public boolean isIdentityNo () {
            return false;
        }
    };


    public abstract String getTypeName();

    public abstract boolean isIdentityNo();

    @Override
    public String description() {
        return this.ordinal() + "-" + this.getTypeName();
    }
}
