package com.bcxin.Infrastructures.entities;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * 事件的基类
 */
@MappedSuperclass
@Getter
@Setter(AccessLevel.PROTECTED)
public abstract class EventEntityAbstract extends OpEntityAbstract {
    @Id
    private String id;
    /**
     * 事件的版本
     */
    @Column(name = "version", nullable = false)
    private Long version;

    @Column(name = "created_time", nullable = false)
    private Timestamp createdTime;

    @Column(name = "map_key", length = 200)
    private String mapKey;

    protected EventEntityAbstract() {
        this.setVersion(Instant.now().getEpochSecond());
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }
}
