package com.bcxin.Infrastructures.components;

import com.bcxin.Infrastructures.components.models.CacheItemAbstract;

import java.util.function.Supplier;

public interface CacheV2Provider {
    <T> T get(String key, Supplier<T> supplier);

    <T> T get(String key, Supplier<T> supplier, int inSeconds);

    <T> void put(String key, T data, int inSeconds);

    void del(String... keys);

    public static String getCacheV2Key(String id) {
        return String.format("redis:cache2:v2:%s", id);
    }

    void delFuzzy(String key);
}
