-- 离职师资校验功能 - 索引优化脚本
-- 用于提升 vm_not_matched_employee_leave_condition 视图的查询性能

-- =====================================================
-- 1. tlk_level_class_student 表索引优化
-- =====================================================
-- 优化等级证成绩查询性能，避免全表扫描
-- 当前问题：执行计划显示 ALL (294行全表扫描)

-- 检查现有索引
SHOW INDEX FROM tms.tlk_level_class_student WHERE Key_name LIKE '%IDCARD%' OR Key_name LIKE '%SCORE%';

-- 创建复合索引（如果不存在）
CREATE INDEX idx_idcardno_scorestate 
ON tms.tlk_level_class_student(ITEM_IDCARDNO, ITEM_SCORESTATE);

-- 说明：
-- - ITEM_IDCARDNO 用于 JOIN 条件
-- - ITEM_SCORESTATE 用于 WHERE 过滤
-- - 复合索引可以完全覆盖查询需求

-- =====================================================
-- 2. tlk_grade_registration 表索引优化
-- =====================================================
-- 优化等级证申报查询性能

-- 检查现有索引
SHOW INDEX FROM tms.tlk_grade_registration WHERE Key_name LIKE '%securityId%' OR Key_name LIKE '%DOMAIN%' OR Key_name LIKE '%applyStatus%';

-- 创建复合索引（如果不存在）
CREATE INDEX idx_securityid_domainid_applystatus 
ON tms.tlk_grade_registration(ITEM_securityId, DOMAINID, ITEM_applyStatus);

-- 说明：
-- - ITEM_securityId 用于与员工表关联
-- - DOMAINID 用于组织过滤
-- - ITEM_applyStatus 用于状态过滤

-- =====================================================
-- 3. tlk_faculty_information 表索引优化
-- =====================================================
-- 优化师资信息查询性能（新增功能）

-- 检查现有索引
SHOW INDEX FROM baibaodunflow.tlk_faculty_information WHERE Key_name LIKE '%PERSON%' OR Key_name LIKE '%DOMAIN%' OR Key_name LIKE '%DELETE%';

-- 创建复合索引（如果不存在）
CREATE INDEX idx_personid_domainid_isdelete 
ON baibaodunflow.tlk_faculty_information(ITEM_PERSON_ID, DOMAINID, ITEM_IS_DELETE);

-- 说明：
-- - ITEM_PERSON_ID 用于与员工表关联
-- - DOMAINID 用于组织过滤
-- - ITEM_IS_DELETE 用于删除状态过滤

-- =====================================================
-- 4. tlk_qualify_person_apply 表索引检查
-- =====================================================
-- 该表已有索引 index_tlk_qualify_person_apply_ITEM_SECURITYID
-- 根据执行计划，该索引工作良好，无需额外优化

SHOW INDEX FROM tms.tlk_qualify_person_apply WHERE Key_name LIKE '%SECURITY%' OR Key_name LIKE '%APPLYSTATUS%';

-- 可选：如果查询仍然慢，可以考虑创建复合索引
-- CREATE INDEX idx_securityid_domainid_applystatus 
-- ON tms.tlk_qualify_person_apply(ITEM_SECURITYID, DOMAINID, ITEM_APPLYSTATUS);

-- =====================================================
-- 5. 验证索引效果
-- =====================================================
-- 执行以下查询查看优化后的执行计划

EXPLAIN 
SELECT
    e.id,
    CONCAT(u.name, '[', c.number, ']') AS info
FROM vm_not_matched_employee_leave_condition v
WHERE v.id IN ('164904','6ZAL0AM5c3Xw4ZGAq1S','aapkEZsf_101023');

-- =====================================================
-- 6. 索引维护建议
-- =====================================================
-- 定期分析表，更新索引统计信息
ANALYZE TABLE tms.tlk_level_class_student;
ANALYZE TABLE tms.tlk_grade_registration;
ANALYZE TABLE baibaodunflow.tlk_faculty_information;
ANALYZE TABLE tms.tlk_qualify_person_apply;

-- =====================================================
-- 预期性能提升
-- =====================================================
-- 优化前：DEPENDENT SUBQUERY + ALL (全表扫描)
-- 优化后：LEFT JOIN + 索引查找
-- 预期提升：5-10倍性能提升
--
-- 关键指标：
-- - 消除 DEPENDENT SUBQUERY
-- - 消除 ALL (全表扫描)
-- - 减少 Using temporary
-- - 子查询只执行一次，而不是对每一行都执行

