/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.utils.poi;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.merge.LoopMergeStrategy;
import com.bcxin.infrastructure.offices.utils.EmployeeCellWriteHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static void main(String[] args) {
        ArrayList<String> titleList = new ArrayList<String>();
        titleList.add("\u5ba2\u6237\u540d\u79f0");
        titleList.add("\u5ba2\u6237\u7f16\u53f7");
        titleList.add("\u4f9b\u5e94\u5546\u540d\u79f0");
        titleList.add("\u5408\u540c\u540d\u79f0");
        titleList.add("\u5408\u540c\u7f16\u53f7");
        titleList.add("\u8981\u5408\u5e76");
        ArrayList<String> mergeTitles = new ArrayList<String>();
        mergeTitles.add("\u5ba2\u6237\u540d\u79f0");
        mergeTitles.add("\u4f9b\u5e94\u5546\u540d\u79f0");
        mergeTitles.add("\u5408\u540c\u7f16\u53f7");
        ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
        for (int i = 0; i < 10; ++i) {
            ArrayList<String> objList = new ArrayList<String>();
            objList.add("\u5ba2\u6237\u540d\u79f0");
            objList.add("\u5ba2\u6237\u7f16\u53f7" + i);
            objList.add("\u4f9b\u5e94\u5546\u540d\u79f0" + i);
            objList.add("\u5408\u540c\u540d\u79f0" + i);
            objList.add("\u5408\u540c\u7f16\u53f7");
            objList.add("\u8981\u5408\u5e76" + i);
            dataList.add(objList);
        }
        ExcelUtils.customDynamicExport("d:/", "\u6d4b\u8bd5\u5bfc\u51faexcel" + Math.random(), titleList, mergeTitles, dataList);
    }

    public static String customDynamicExport(String filePath, String fileName, List<String> titleList, List<String> mergeTitles, List<List<Object>> dataList) {
        fileName = filePath + fileName + ".xlsx";
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        HashMap<String, List<Object>> dataMap = new HashMap<String, List<Object>>(titleList.size());
        for (int i = 0; i < titleList.size(); ++i) {
            ArrayList<Object> currectTitleDatas = new ArrayList<Object>();
            for (int j = 0; j < dataList.size(); ++j) {
                currectTitleDatas.add(dataList.get(j).get(i));
            }
            dataMap.put(titleList.get(i), currectTitleDatas);
        }
        List<List<String>> headTitleInfo = ExcelUtils.excelTitle(titleList);
        List<List<Object>> excelDataInfo = ExcelUtils.excelData(dataList);
        List<LoopMergeStrategy> mergeStrategies = ExcelUtils.mergeCells(titleList, mergeTitles, dataMap);
        ExcelWriterBuilder excelWriterBuilder = EasyExcel.write((String)fileName);
        if (!CollectionUtils.isEmpty(mergeStrategies)) {
            log.info("\u5f00\u59cb\u8fdb\u884c\u5408\u5e76\u5355\u5143\u683c\u64cd\u4f5c mergeStrategies ===> {}", mergeStrategies);
            mergeStrategies.forEach(m -> excelWriterBuilder.registerWriteHandler((WriteHandler)m));
        }
        ((ExcelWriterBuilder)((ExcelWriterBuilder)excelWriterBuilder.registerWriteHandler((WriteHandler)new EmployeeCellWriteHandler())).head(headTitleInfo)).sheet("\u6a21\u677f").doWrite(excelDataInfo);
        return fileName;
    }

    private static List<List<String>> excelTitle(List<String> titleList) {
        if (CollectionUtils.isEmpty(titleList)) {
            log.error("====> \u5bfc\u51faexcel\u6807\u9898\u4e3a\u7a7a");
            throw new RuntimeException();
        }
        ArrayList<List<String>> excelTitleList = new ArrayList<List<String>>(titleList.size());
        titleList.forEach(k -> {
            ArrayList<String> titles = new ArrayList<String>(1);
            titles.add((String)k);
            excelTitleList.add(titles);
        });
        return excelTitleList;
    }

    private static List<List<Object>> excelData(List<List<Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            log.error("===> \u5bfc\u51faexcel\u6570\u636e\u4e3a\u7a7a");
            throw new RuntimeException();
        }
        return dataList;
    }

    private static List<LoopMergeStrategy> mergeCells(List<String> titleList, List<String> mergeTitles, Map<String, List<Object>> dataMap) {
        if (CollectionUtils.isEmpty(titleList)) {
            log.error("====> \u5bfc\u51faexcel\u6807\u9898\u4e3a\u7a7a");
            throw new RuntimeException();
        }
        if (CollectionUtils.isEmpty(mergeTitles)) {
            log.warn("\u8be5\u6b21\u5bfc\u51fa\u65e0\u5408\u5e76\u5355\u5143\u683c\u64cd\u4f5c");
            return new ArrayList<LoopMergeStrategy>();
        }
        Map<String, String> mergeTitleMap = mergeTitles.stream().collect(Collectors.toMap(k -> k, k -> k));
        HashMap<String, Integer> mergeLocationMap = new HashMap<String, Integer>(mergeTitles.size());
        for (int i = 0; i < titleList.size(); ++i) {
            if (!Objects.nonNull(mergeTitleMap.get(titleList.get(i)))) continue;
            mergeLocationMap.put(titleList.get(i), i);
        }
        ArrayList<LoopMergeStrategy> mergeStrategyList = new ArrayList<LoopMergeStrategy>();
        mergeTitles.forEach(k -> {
            Integer columnIndex = (Integer)mergeLocationMap.get(k);
            List mergeDatas = (List)dataMap.get(k);
            Integer currectMergeNum = 1;
            for (int m = 0; m < mergeDatas.size(); ++m) {
                Boolean isMerge = false;
                if (m != 0 && Objects.equals(mergeDatas.get(m), mergeDatas.get(m - 1))) {
                    isMerge = true;
                    currectMergeNum = currectMergeNum + 1;
                    if (m == mergeDatas.size() - 1) {
                        isMerge = false;
                    }
                }
                if (isMerge.booleanValue() || currectMergeNum <= 1) continue;
                Integer eachRow = currectMergeNum;
                mergeStrategyList.add(new LoopMergeStrategy(eachRow.intValue(), columnIndex.intValue()));
                currectMergeNum = 1;
            }
        });
        return mergeStrategyList;
    }
}

