/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.validations.TelephoneValidator;
import org.springframework.util.StringUtils;

public class UpdateBasicTenantUserCommand
extends CommandAbstract {
    private final String id;
    private final String name;
    private final String telephone;

    public UpdateBasicTenantUserCommand(String id, String name, String telephone) {
        this.name = name;
        this.telephone = telephone;
        this.id = id;
    }

    public static UpdateBasicTenantUserCommand create(String id, String name, String telephone) {
        return new UpdateBasicTenantUserCommand(id, name, telephone);
    }

    public void validate(boolean isRequiredPhoneAsLoginName) {
        if (!StringUtils.hasLength((String)this.getId())) {
            throw new ArgumentTenantException("Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getName())) {
            throw new ArgumentTenantException("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (isRequiredPhoneAsLoginName) {
            if (!StringUtils.hasLength((String)this.getTelephone())) {
                throw new ArgumentTenantException("\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.getTelephone() != null && this.getTelephone().length() > 30) {
                throw new ArgumentTenantException("\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u4e09\u5341\u4f4d");
            }
        } else {
            if (!StringUtils.hasLength((String)this.getTelephone())) {
                throw new ArgumentTenantException("\u624b\u673a\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!TelephoneValidator.checkIsValid((String)this.getTelephone())) {
                throw new ArgumentTenantException("\u624b\u673a\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTelephone() {
        return this.telephone;
    }
}

