/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.repository.customize;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.domain.entities.DepartmentAdminEntity;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.repositories.DepartmentAdminRepository;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class DepartmentAdminRepositoryImpl
implements DepartmentAdminRepository {
    private final EntityManager entityManager;
    private final UnitWork unitWork;

    public DepartmentAdminRepositoryImpl(EntityManager entityManager, UnitWork unitWork) {
        this.entityManager = entityManager;
        this.unitWork = unitWork;
    }

    public void create(DepartmentAdminEntity departmentAdmin) {
        ((Session)this.entityManager.unwrap(Session.class)).persist((Object)departmentAdmin);
        this.entityManager.flush();
    }

    public void update(List<DepartmentAdminEntity> departmentAdminList) {
        for (DepartmentAdminEntity departmentAdminEntity : departmentAdminList) {
            ((Session)this.entityManager.unwrap(Session.class)).update((Object)departmentAdminEntity);
        }
    }

    public void batchCreate(Collection<EmployeeEntity> employees, Collection<DepartmentEntity> departments) {
        if (CollectionUtils.isEmpty(employees) || CollectionUtils.isEmpty(departments)) {
            throw new BadTenantException("\u804c\u5458/\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.unitWork.executeTran(() -> {
                for (EmployeeEntity employee : employees) {
                    Query deleteQuery = this.entityManager.createQuery("delete from DepartmentAdminEntity t where t.employee.id=?1 and t.department.id in (?2)");
                    deleteQuery.setParameter(1, (Object)employee.getId());
                    deleteQuery.setParameter(2, departments.stream().map(ix -> ix.getId()).collect(Collectors.toList()));
                    deleteQuery.executeUpdate();
                    for (DepartmentEntity department : departments) {
                        DepartmentAdminEntity departmentAdmin = DepartmentAdminEntity.create((DepartmentEntity)department, (EmployeeEntity)employee);
                        ((Session)this.entityManager.unwrap(Session.class)).persist((Object)departmentAdmin);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new BadTenantException("\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
    }

    public void update(EmployeeEntity employee, Collection<DepartmentEntity> departments) {
        if (employee == null || CollectionUtils.isEmpty(departments)) {
            throw new BadTenantException("\u804c\u5458/\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.unitWork.executeTran(() -> {
                Query deleteQuery = this.entityManager.createQuery("delete from DepartmentAdminEntity t where t.employee.id=?1");
                deleteQuery.setParameter(1, (Object)employee.getId());
                deleteQuery.executeUpdate();
                for (DepartmentEntity department : departments) {
                    DepartmentAdminEntity departmentAdmin = DepartmentAdminEntity.create((DepartmentEntity)department, (EmployeeEntity)employee);
                    ((Session)this.entityManager.unwrap(Session.class)).persist((Object)departmentAdmin);
                }
            });
        }
        catch (Exception ex) {
            throw new BadTenantException("\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
    }

    public void batchDelete(Collection<String> employeeIds) {
        if (CollectionUtils.isEmpty(employeeIds)) {
            throw new BadTenantException("\u8981\u5220\u9664\u7684\u804c\u5458\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.unitWork.executeTran(() -> {
            Query deleteQuery = this.entityManager.createQuery("delete from DepartmentAdminEntity u where u.employee.id in (?1)");
            deleteQuery.setParameter(1, (Object)employeeIds);
            deleteQuery.executeUpdate();
        });
    }

    public Collection<DepartmentAdminEntity> getByIds(String organizationId, Collection<String> ids) {
        TypedQuery departmentAdminEntityTypedQuery = this.entityManager.createQuery("select d from DepartmentAdminEntity d where d.organization.id=?1 and d.id in (?2)", DepartmentAdminEntity.class);
        departmentAdminEntityTypedQuery.setParameter(1, (Object)organizationId);
        departmentAdminEntityTypedQuery.setParameter(2, ids);
        return departmentAdminEntityTypedQuery.getResultList();
    }

    public Collection<DepartmentAdminEntity> getByEmployeeIds(String organizationId, Collection<String> employeeIds) {
        TypedQuery departmentAdminEntityTypedQuery = this.entityManager.createQuery("select d from DepartmentAdminEntity d where d.organization.id=?1 and d.employee.id in (?2)", DepartmentAdminEntity.class);
        departmentAdminEntityTypedQuery.setParameter(1, (Object)organizationId);
        departmentAdminEntityTypedQuery.setParameter(2, employeeIds);
        return departmentAdminEntityTypedQuery.getResultList();
    }

    public List<DepartmentAdminEntity> getByDepartmentId(String departmentId) {
        TypedQuery departmentAdminEntityTypedQuery = this.entityManager.createQuery("select d from DepartmentAdminEntity d where d.department.id=?1 ", DepartmentAdminEntity.class);
        departmentAdminEntityTypedQuery.setParameter(1, (Object)departmentId);
        return departmentAdminEntityTypedQuery.getResultList();
    }
}

