package com.bcxin.api.interfaces.tenants.responses;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.utils.CdnUtils;
import lombok.Getter;

import java.io.Serializable;

@Getter
public class ImContactResponse implements Serializable {
    private String id;
    private String name;
    private String headPhoto;
    private String telephone;
    private String idNum;
    private String imIdentity;
    private String sex;
    private String oneInchColorWhitePhoto;

    public ImContactResponse(String id, String name, String headPhoto, String telephone, String idNum, String imIdentity, Sex sex,String oneInchColorWhitePhoto) {
        this.id = id;
        this.name = name;
        this.headPhoto = CdnUtils.convert(headPhoto);
        this.telephone = telephone;
        this.imIdentity = imIdentity;
        this.idNum = idNum;
        this.sex = "未知";
        if(sex != null){
            this.sex = sex.getTypeName();
        };
        this.oneInchColorWhitePhoto = CdnUtils.convert(oneInchColorWhitePhoto);
    }

    public static ImContactResponse create(String id,String name, String headPhoto, String telephone, String idNum, String imIdentity, Sex sex,String oneInchColorWhitePhoto) {
        return new ImContactResponse(id,name, headPhoto, telephone, idNum, imIdentity, sex, oneInchColorWhitePhoto);
    }
}
