package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import lombok.AllArgsConstructor;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class CredentialResponse implements Serializable {

    /**
     * 证件姓名
     */
    private String name;

    private CredentialType credentialType;
    private String credentialTypeName;

    private String number;

    private Date validDateFrom;

    private Date validDateTo;
    /**
     * 证件头像
     */
    private String headPhoto;

    /**
     * 正面照：比如: 身份证人像面
     */
    private String frontPhoto;

    /**
     * 反面照：比如: 身份证国徽面
     */
    private String reversePhoto;

    /**
     * 证件地址: 比如: 身份证住址
     */
    private String address;

    private Timestamp createdTime;

    private List<Map> detail;

    public CredentialResponse() {
    }

    public CredentialResponse(String name, CredentialType credentialType,String  credentialTypeName, String number, Date validDateFrom, Date validDateTo, String headPhoto, String frontPhoto, String reversePhoto, String address, Timestamp createdTime) {
        this.name = name;
        this.credentialType = credentialType;
        this.credentialTypeName = credentialTypeName;
        this.number = number;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.headPhoto = headPhoto;
        this.frontPhoto = frontPhoto;
        this.reversePhoto = reversePhoto;
        this.address = address;
        this.createdTime = createdTime;
    }
}
