package com.bcxin.api.interfaces.tenants.requests.tenantUsers;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.Date;


@Getter
public class UpdateCredentialImageRequest extends RequestAbstract {

    @ApiModelProperty(value = "人头像")
    private final String headPhoto;

    @ApiModelProperty(value = "身份证人像面")
    private final String frontPhoto;

    @ApiModelProperty(value = "身份证国徽面")
    private final String reversePhoto;

    @ApiModelProperty(value = "身份证地址")
    private final String address;

    @ApiModelProperty(value = "有效期从")
    private final Date validDateFrom;

    @ApiModelProperty(value = "有效期到")
    private final Date validDateTo;

    public UpdateCredentialImageRequest(String headPhoto, String frontPhoto, String reversePhoto,
                                        String address,Date validDateFrom,Date validDateTo) {
        this.headPhoto = headPhoto;
        this.frontPhoto = frontPhoto;
        this.reversePhoto = reversePhoto;
        this.address = address;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
    }
}
