package com.bcxin.api.interfaces.security.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

import javax.persistence.Column;
import java.util.Date;

/**
 * @author linqinglin
 * @date 2021/12/11 0011 15:32
 */
@Getter
public class CertificateResponse extends ResponseAbstract {

    private final String id;

    /**
     * 姓名
     */
    private String name;

    /**
     * 身份证号
     */
    private String idNum;

    /**
     * 证书类型 1资格证 2等级证
     */
    private String cerType;

    /**
     * 等级
     */
    private String level;

    /**
     * 证书编号
     */
    private String cerNo;
    /**
     * 发证机关
     */
    private String cerFrom;
    /**
     * 发证日期
     */
    private Date cerDate;

    /**
     * 状态
     */
    private String status;

    public CertificateResponse(String id,
                               String name,
                               String idNum,
                               String cerType,
                               String level,
                               String cerNo,
                               String cerFrom,
                               Date cerDate,
                               String status){
        this.id = id;
        this.name = name;
        this.idNum = idNum;
        this.cerType = cerType;
        this.level = level;
        this.cerNo = cerNo;
        this.cerFrom = cerFrom;
        this.cerDate = cerDate;
        this.status = status;
    }


    public static CertificateResponse create(String id,
                                             String name,
                                             String idNum,
                                             String cerType,
                                             String level,
                                             String cerNo,
                                             String cerFrom,
                                             Date cerDate,
                                             String status) {
        return new CertificateResponse(id,
                name,
                idNum,
                cerType,
                level,
                cerNo,
                cerFrom,
                cerDate,
                status);
    }
}
