package com.bcxin.api.interfaces.rbacs.custom.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@ApiModel("角色id-职员id列表-对象")
@Data
public class RbacCustomRoleIdEmployeeIdListRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "角色id")
    @NotNull(message = "角色id不能为空")
    private Long roleId;

    @ApiModelProperty(value = "职员id列表")
    @NotEmpty(message = "职员id不能为空")
    private List<String> employeeIdList;

}
