package com.bcxin.api.interfaces.identities.responses;

import com.bcxin.Infrastructures.SystemConstant;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.utils.JwtUtil;
import com.bcxin.api.interfaces.ResponseAbstract;
import com.bcxin.api.interfaces.identities.valueTypes.WechatCgiBinSubject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

@Getter
public class TocUserConfirmCheckStatusResponse extends ResponseAbstract {
    /**
     * 小程序Token
     * 区别于智能人事的AuthenticationToken和AccessToken
     */
    @ApiModelProperty("小程序登入的认证信息; 未绑定用户之前; 用于调用: /wechat/cgi-bin/current")
    private final String cgiToken;

    @ApiModelProperty("仅当关联了用户信息之后(百保盾用户绑定微信或者身份核验之后, 此才有值);那么通过token调用/tenant/users/current 获取用户信息")
    private final String token;

    public TocUserConfirmCheckStatusResponse(String cgiToken, String token) {
        this.cgiToken = cgiToken;
        this.token = token;
    }

    public static TocUserConfirmCheckStatusResponse create(String cgiToken, String token) {
        return new TocUserConfirmCheckStatusResponse(cgiToken, token);
    }
}
