package com.bcxin.security.api.impls;

import com.alibaba.excel.EasyExcel;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.security.CertificateRpcProvider;
import com.bcxin.api.interfaces.security.responses.CertificateResponse;
import com.bcxin.api.interfaces.tenants.requests.employees.BatchCerExcelRequest;
import com.bcxin.security.domains.configs.PlatformUploadConfig;
import com.bcxin.security.domains.dtos.CertificateExportDto;
import com.bcxin.security.domains.entities.CertificateEntity;
import com.bcxin.security.domains.repositories.CertificateRepository;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2021/12/11 0011 15:21
 */

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class CertificateRpcProviderImpl implements CertificateRpcProvider {

    public static Logger logger = LoggerFactory.getLogger(CertificateRpcProviderImpl.class);

    private final CertificateRepository certificateRepository;

    public CertificateRpcProviderImpl(CertificateRepository certificateRepository){
        this.certificateRepository = certificateRepository;
    }

    @Override
    public List<CertificateResponse> list(List<String> idNums) {
//        EasyExcel.write(path,LeaveEmployeeExportDto.class).sheet().doWrite(list);
        Collection<CertificateEntity> list = certificateRepository.list(idNums);

        if(list.size() > 0) {
            List<CertificateResponse> responses = new ArrayList<>();
            for (CertificateEntity certificateEntity : list) {
                responses.add(CertificateResponse.create(certificateEntity.getId(),
                        certificateEntity.getName(),
                        certificateEntity.getIdNum(),
                        certificateEntity.getCerType(),
                        certificateEntity.getLevel(),
                        certificateEntity.getCerNo(),
                        certificateEntity.getCerFrom(),
                        certificateEntity.getCerDate(),
                        certificateEntity.getStatus()
                ));
            }
            return responses;
        }
        return null;

    }

    @Override
    public String batchQueryCerInfos(Collection<BatchCerExcelRequest> batchCerExcelRequests) {
        Collection<CertificateEntity> list = certificateRepository.list(batchCerExcelRequests.stream().map(BatchCerExcelRequest::getIdNum).collect(Collectors.toList()));
        Map<String,List<CertificateEntity>> cerMaps = list.stream().collect(Collectors.groupingBy(CertificateEntity::getIdNum));
        List<CertificateExportDto> result = new ArrayList<>();
        for (BatchCerExcelRequest batchCerExcelRequest : batchCerExcelRequests) {
            CertificateExportDto certificateExportDto = CertificateExportDto.create(batchCerExcelRequest.getName(),batchCerExcelRequest.getIdNum());

            List<CertificateEntity> subList = cerMaps.get(batchCerExcelRequest.getIdNum());

            if(subList != null && subList.size() > 0){
                List<CertificateEntity> subCerList = new ArrayList<>();
                List<CertificateEntity> subGrade5CerList = new ArrayList<>();
                List<CertificateEntity> subGrade4CerList = new ArrayList<>();
                Map<String,List<CertificateEntity>> subCerMaps = subList.stream().collect(Collectors.groupingBy(CertificateEntity::getCerType));
                //资格证
                if(subCerMaps.get("1") != null){
                    subCerList = subCerMaps.get("1").stream()
                            .sorted(Comparator.comparing(CertificateEntity::getStatus).reversed())
                            .sorted(Comparator.comparing(CertificateEntity::getCerDate).reversed())
                            .collect(Collectors.toList());
                }
                //等级证
                if(subCerMaps.get("2") != null){
                    List<CertificateEntity> subGradeCerList = subCerMaps.get("2");
                    Map<String,List<CertificateEntity>> subGradeCerMaps = subGradeCerList.stream().collect(Collectors.groupingBy(CertificateEntity::getLevel));
                    //五级
                    if(subGradeCerMaps.get("5") != null){
                        subGrade5CerList = subGradeCerMaps.get("5").stream()
                                .sorted(Comparator.comparing(CertificateEntity::getStatus).reversed())
                                .sorted(Comparator.comparing(CertificateEntity::getCerDate).reversed())
                                .collect(Collectors.toList());
                    }
                    //四级
                    if(subGradeCerMaps.get("4") != null){
                        subGrade4CerList = subGradeCerMaps.get("4").stream()
                                .sorted(Comparator.comparing(CertificateEntity::getStatus).reversed())
                                .sorted(Comparator.comparing(CertificateEntity::getCerDate).reversed())
                                .collect(Collectors.toList());
                    }
                }
                if(subCerList.size() > 0){
                    CertificateEntity certificateEntity = subCerList.get(0);
                    certificateExportDto.setCerNo(certificateEntity.getCerNo());
                    certificateExportDto.setCerFrom(certificateEntity.getCerFrom());
                    certificateExportDto.setCerDate(certificateEntity.getCerDate());
                    certificateExportDto.setStatus("0".equals(certificateEntity.getStatus())?"吊销":"正常");
                }
                if(subGrade5CerList.size() > 0){
                    CertificateEntity cerGrade5Entity = subGrade5CerList.get(0);
                    certificateExportDto.setGrade5CerNo(cerGrade5Entity.getCerNo());
                    certificateExportDto.setGrade5CerFrom(cerGrade5Entity.getCerFrom());
                    certificateExportDto.setGrade5CerDate(cerGrade5Entity.getCerDate());
                    certificateExportDto.setGrade5Status("0".equals(cerGrade5Entity.getStatus())?"吊销":"正常");
                }
                if(subGrade4CerList.size() > 0){
                    CertificateEntity cerGrade4Entity = subGrade4CerList.get(0);
                    certificateExportDto.setGrade4CerNo(cerGrade4Entity.getCerNo());
                    certificateExportDto.setGrade4CerFrom(cerGrade4Entity.getCerFrom());
                    certificateExportDto.setGrade4CerDate(cerGrade4Entity.getCerDate());
                    certificateExportDto.setGrade4Status("0".equals(cerGrade4Entity.getStatus())?"吊销":"正常");
                }
            }
            result.add(certificateExportDto);
        }

        String relativePath = String.format("/uploads/download/%s/%s/证书查询结果.xlsx", DateUtil.format2ShortDate(new Date()),UUID.randomUUID());

        String path = PlatformUploadConfig.getPath()+relativePath;
        File file = new File(path);
        if(!file.getParentFile().exists()){
            file.getParentFile().mkdirs();
        }
        EasyExcel.write(path, CertificateExportDto.class).sheet().doWrite(result);

        return relativePath;
    }

}
