package com.bcxin.Infrastructures.validations;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

public class TelephoneValidator implements ConstraintValidator<Telephone,String> {
    private static final String PHONE_PATTERN ="^[0-9]{11}$";//"^1[0-9]{10}$";
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        return checkIsValid(value);
    }

    public static boolean checkIsValid(String value)
    {
        try {
            return  Pattern.matches(PHONE_PATTERN,value);
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return false;
    }
}