package com.bcxin.Infrastructures.utils;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.entities.OperatorValueType;

public class AuthUtil {

    public static boolean isBeiJingCompany(){
        if(getAreaCode().startsWith("11")){
            return true;
        }
        return false;
    }

    public static boolean isBeijingCompany(String areaCode) {
        if (!StringUtils.isEmpty(areaCode) && areaCode.startsWith("11")) {
            return true;
        }

        return false;
    }
    public static boolean isHunanCompany(String areaCode) {
        if (!StringUtils.isEmpty(areaCode) && areaCode.startsWith("43")) {
            return true;
        }

        return false;
    }
    public static boolean isNingxiaCompany(String areaCode) {
        if (!StringUtils.isEmpty(areaCode) && areaCode.startsWith("64")) {
            return true;
        }

        return false;
    }

    public static boolean isShanxiCompany(String areaCode) {
        if (!StringUtils.isEmpty(areaCode) && areaCode.startsWith("61")) {
            return true;
        }

        return false;
    }

    public static boolean isUnDistinguishArea(){
        //湖南、宁夏 证书不区分证书
        if(getAreaCode().startsWith("43") || getAreaCode().startsWith("64")){
            return true;
        }
        return false;
    }

    public static boolean isUnDistinguishArea(String areaCode){
        //湖南、宁夏 证书不区分证书
        if(areaCode.startsWith("43") || areaCode.startsWith("64")){
            return true;
        }
        return false;
    }

    public static String getAreaCode(){
        try{
            if(TenantContext.getInstance() != null && TenantContext.getInstance().getUserContext() != null) {
                return TenantContext.getInstance().getUserContext().getAreaCode();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return "";
    }

    public static String getShortAreaCode(){
        String areaCode = getAreaCode();
        if(StrUtil.isNotEmpty(areaCode) && areaCode.length() >= 2){
            return areaCode.substring(0,2);
        }
        return "";
    }
    public static String getShortAreaCode(String areaCode){
        if(StrUtil.isNotEmpty(areaCode) && areaCode.length() >= 2){
            return areaCode.substring(0,2);
        }
        return "";
    }

    public static OperatorValueType getCurrentOperator(){
        /**
         * 当前操作者, 可以为当前用户/也可以是固定后台用户
         */
        if(TenantContext.getInstance() == null
         || TenantContext.getInstance().getUserContext() == null
         || TenantContext.getInstance().getUserContext().get() == null
        ){
            return OperatorValueType.create(null,null);
        }

        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        return OperatorValueType.create(currentUser.getId(), currentUser.getName());
    }

    public static boolean isAdmin(){
        /**
         * 当前操作者, 可以为当前用户/也可以是固定后台用户
         */
        if(TenantContext.getInstance() == null
         || TenantContext.getInstance().getUserContext() == null
         || TenantContext.getInstance().getUserContext().get() == null
        ){
            return false;
        }
        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        return currentUser.isMaster();
    }
}
