package com.bcxin.Infrastructures.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;
@Getter
public enum OrganizationLevel {
    Basic(1<<0,"基本包"),
    Premium(1<<1,"高级包");

    int value;
    String name;
    private OrganizationLevel(int value, String name) {
        this.value = value;
        this.name = name;
    }
    public static int calculate(Collection<OrganizationLevel> organizationLevels) {
        int result = 0;
        if (organizationLevels != null || !organizationLevels.isEmpty()) {
            for (OrganizationLevel organizationLevel : organizationLevels) {
                result |= organizationLevel.value;
            }
        }
        return result;
    }
    public static Collection<OrganizationLevel> getSelectedOrganizationLevels(int organizationLevel) {
        Collection<OrganizationLevel> result = new ArrayList<>();
        for (OrganizationLevel organizationLevel1 : OrganizationLevel.values()) {
            if ((organizationLevel & organizationLevel1.value) > 0) {
                result.add(organizationLevel1);
            }
        }
        return result;
    }

    public static boolean contain(int organizationLevelValue, OrganizationLevel organizationLevel) {
        return getSelectedOrganizationLevels(organizationLevelValue).contains(organizationLevel);
    }
}
