package com.bcxin.Infrastructures;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TenantUserContext implements ContextAware<TenantUserContext.UserModel> {
    public static final String CURRENT_TENANT_USER_INFO = "API.CURRENT_TENANT_USER_INFO";
    private static final ThreadLocal<UserModel> _userContextThread = new ThreadLocal<>();

    @Override
    public UserModel get() {
        return _userContextThread.get();
    }

    @Override
    public void init(UserModel data) {
        _userContextThread.set(data);
    }

    public void init(String token, String tenantUserId) {
        _userContextThread.set(UserModel.create(token, tenantUserId));
    }

    public void assignDetail(String name,String organId,String organName,String employeeId,MasterSlaveType masterSlaveType,boolean isDomainAdmin,
                             boolean isDepartAdmin,
                             String areaCode) {
        UserModel model = _userContextThread.get();
        if (model == null) {
            throw new ArgumentTenantException("当前用户上下文无效, 系统未能在AuthFilter执行初始化");
        }

        model.assignDetail(name, organId,organName, employeeId, masterSlaveType,isDomainAdmin,isDepartAdmin,areaCode);

        _userContextThread.set(model);
    }

    public boolean isDomainAdmin() {
        UserModel model = _userContextThread.get();
        if (model == null) {
            return false;
        }

        return model.isMaster();
    }

    public String getAreaCode() {
        UserModel model = _userContextThread.get();
        if (model == null) {
            return "";
        }

        return StrUtil.isNotEmpty(model.getAreaCode()) ? model.getAreaCode():"";
    }

    public void reset() {
        _userContextThread.set(null);
    }

    @Getter
    public static class UserModel implements Serializable {
        private final String token;
        private final String id;

        private String name;
        private String organId;
        private String organName;
        private String employeeId;

        /**
         * 组织管理员
         */
        private boolean isMaster;
        private String areaCode;
        private boolean isDepartAdmin = false;
        private final boolean leaveDatedLimited = true;
        private final Map<String, Object> attachments = new HashMap<>();

        public UserModel(String token, String id) {
            this.id = id;
            this.token = token;
        }

        public void assignDetail(String name, String organId, String organName, String employeeId, MasterSlaveType masterSlaveType,boolean isDomainAdmin,
                                 boolean isDepartAdmin,
                                 String areaCode) {
            this.name = name;
            this.organId = organId;
            this.organName = organName;
            this.employeeId = employeeId;
            //this.isMaster = masterSlaveType == MasterSlaveType.Master || isDomainAdmin;
            this.isMaster = isDomainAdmin;
            this.isDepartAdmin = isDepartAdmin;
            this.areaCode = areaCode;
        }

        public static UserModel create(String token, String id) {
            return new UserModel(token, id);
        }
    }
}
