/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.MetaPageEntity;
import com.bcxin.tenant.bcx.domains.entities.MetaPageVersionEntity;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageRepository;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageVersionRepository;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaPageSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.MetaPageService;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.BatchLogicalDeletePageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.CreateMetaPageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.LogicalDeletePageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.UpdateMetaPageCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import java.sql.Timestamp;
import org.springframework.stereotype.Service;

@Service
public class MetaPageServiceImpl
implements MetaPageService {
    private final MetaPageRepository pageRepository;
    private final MetaPageVersionRepository versionRepository;
    private final UnitWork unitWork;
    private final IdWorker idWorker;

    public MetaPageServiceImpl(MetaPageRepository pageRepository, MetaPageVersionRepository versionRepository, UnitWork unitWork, IdWorker idWorker) {
        this.pageRepository = pageRepository;
        this.versionRepository = versionRepository;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreateMetaPageCommand command) {
        command.validate();
        if (StringUtil.isEmpty((String)command.getName())) {
            throw new IllegalArgumentException("\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (command.getPageType() == null) {
            throw new IllegalArgumentException("\u9875\u9762\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.unitWork.executeTran(() -> {
            String id = String.valueOf(this.idWorker.getNextId());
            MetaPageEntity entity = new MetaPageEntity();
            entity.setId(id);
            entity.setProjectId(command.getProjectId());
            entity.setModuleId(command.getModuleId());
            entity.setName(command.getName());
            entity.setNote(command.getNote());
            entity.setSlug(command.getSlug());
            entity.setLogo(command.getLogo());
            entity.setPageType(command.getPageType());
            entity.setBusinessType(command.getBusinessType());
            entity.setTableName(command.getTableName());
            entity.setEnableBPMFlow(command.isEnableBPMFlow());
            entity.setFormJson(command.getFormJson());
            entity.setReferenceType(command.getReferenceType());
            entity.setReferenceNumber(command.getReferenceNumber());
            entity.setCreatorId(command.getCreatorId());
            entity.setVersion(1L);
            entity.setDeleted(false);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            entity.setCreatedTime(now);
            entity.setLastUpdatedTime(now);
            this.pageRepository.insert(entity);
            if (!StringUtil.isEmpty((String)command.getFormJson())) {
                MetaPageVersionEntity versionEntity = new MetaPageVersionEntity();
                versionEntity.setId(String.valueOf(this.idWorker.getNextId()));
                versionEntity.setPageId(id);
                versionEntity.setVersion(1L);
                versionEntity.setFormJson(command.getFormJson());
                versionEntity.setCreatedTime(now);
                this.versionRepository.insert(versionEntity);
            }
        });
    }

    @Override
    public void dispatch(UpdateMetaPageCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaPageEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u9875\u9762\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u66f4\u65b0\u5df2\u5220\u9664\u7684\u9875\u9762\uff0cID: " + command.getId());
            }
            boolean formJsonChanged = false;
            if (command.getName() != null) {
                entity.setName(command.getName());
            }
            if (command.getNote() != null) {
                entity.setNote(command.getNote());
            }
            if (command.getSlug() != null) {
                entity.setSlug(command.getSlug());
            }
            if (command.getLogo() != null) {
                entity.setLogo(command.getLogo());
            }
            if (command.getPageType() != null) {
                entity.setPageType(command.getPageType());
            }
            if (command.getBusinessType() != null) {
                entity.setBusinessType(command.getBusinessType());
            }
            if (command.getTableName() != null) {
                entity.setTableName(command.getTableName());
            }
            if (command.getEnableBPMFlow() != null) {
                entity.setEnableBPMFlow(command.getEnableBPMFlow());
            }
            if (command.getFormJson() != null && !command.getFormJson().equals(entity.getFormJson())) {
                entity.setFormJson(command.getFormJson());
                entity.setVersion(entity.getVersion() + 1L);
                formJsonChanged = true;
            }
            if (command.getLastUpdatorId() != null) {
                entity.setLastUpdatorId(command.getLastUpdatorId());
            }
            entity.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
            this.pageRepository.update(entity);
            if (formJsonChanged) {
                MetaPageVersionEntity versionEntity = new MetaPageVersionEntity();
                versionEntity.setId(String.valueOf(this.idWorker.getNextId()));
                versionEntity.setPageId(entity.getId());
                versionEntity.setVersion(entity.getVersion());
                versionEntity.setFormJson(entity.getFormJson());
                versionEntity.setCreatedTime(entity.getLastUpdatedTime());
                this.versionRepository.insert(versionEntity);
            }
        });
    }

    @Override
    public void dispatch(DeleteDataCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaPageEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u9875\u9762\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u5220\u9664\u5df2\u5220\u9664\u7684\u9875\u9762\uff0cID: " + command.getId());
            }
            this.pageRepository.delete(command.getId());
        });
    }

    @Override
    public void dispatch(LogicalDeletePageCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaPageEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u9875\u9762\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u9875\u9762\u5df2\u88ab\u5220\u9664\uff0cID: " + command.getId());
            }
            entity.markAsDeleted();
            entity.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
            this.pageRepository.update(entity);
        });
    }

    @Override
    public void dispatch(BatchLogicalDeletePageCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            for (String id : command.getIds()) {
                MetaPageEntity entity = this.getByIdIncludeDeleted(id);
                if (entity == null) {
                    throw new IllegalArgumentException("\u9875\u9762\u4e0d\u5b58\u5728\uff0cID: " + id);
                }
                if (entity.isDeleted()) {
                    throw new IllegalArgumentException("\u9875\u9762\u5df2\u88ab\u5220\u9664\uff0cID: " + id);
                }
                entity.markAsDeleted();
                entity.setLastUpdatedTime(now);
                this.pageRepository.update(entity);
            }
        });
    }

    @Override
    public EntityCollection<MetaPageEntity> search(MetaPageSearchCriteria criteria) {
        return this.pageRepository.search(criteria);
    }

    @Override
    public MetaPageEntity getById(String id) {
        MetaPageEntity entity = (MetaPageEntity)this.pageRepository.getById(id);
        if (entity != null && entity.isDeleted()) {
            return null;
        }
        return entity;
    }

    private MetaPageEntity getByIdIncludeDeleted(String id) {
        return (MetaPageEntity)this.pageRepository.getById(id);
    }
}

