/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.MetaMenuEntity;
import com.bcxin.tenant.bcx.domains.repositories.MetaMenuRepository;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaMenuSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.MetaMenuService;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.menus.CreateMetaMenuCommand;
import com.bcxin.tenant.bcx.domains.services.commands.menus.UpdateMetaMenuCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import java.sql.Timestamp;
import org.springframework.stereotype.Service;

@Service
public class MetaMenuServiceImpl
implements MetaMenuService {
    private final MetaMenuRepository menuRepository;
    private final UnitWork unitWork;
    private final IdWorker idWorker;

    public MetaMenuServiceImpl(MetaMenuRepository menuRepository, UnitWork unitWork, IdWorker idWorker) {
        this.menuRepository = menuRepository;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreateMetaMenuCommand command) {
        command.validate();
        if (StringUtil.isEmpty((String)command.getName())) {
            throw new IllegalArgumentException("\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.unitWork.executeTran(() -> {
            String id = String.valueOf(this.idWorker.getNextId());
            MetaMenuEntity entity = new MetaMenuEntity();
            entity.setId(id);
            entity.setProjectId(command.getProjectId());
            entity.setName(command.getName());
            entity.setPageId(command.getPageId());
            entity.setParentId(command.getParentId());
            entity.setIndexTreeId(command.getIndexTreeId());
            entity.setSlug(command.getSlug());
            entity.setMediumType(command.getMediumType());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            entity.setCreatedTime(now);
            entity.setLastUpdatedTime(now);
            this.menuRepository.insert(entity);
        });
    }

    @Override
    public void dispatch(UpdateMetaMenuCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaMenuEntity entity = (MetaMenuEntity)this.menuRepository.getById(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u83dc\u5355\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (command.getName() != null) {
                entity.setName(command.getName());
            }
            if (command.getPageId() != null) {
                entity.setPageId(command.getPageId());
            }
            if (command.getParentId() != null) {
                entity.setParentId(command.getParentId());
            }
            if (command.getIndexTreeId() != null) {
                entity.setIndexTreeId(command.getIndexTreeId());
            }
            if (command.getSlug() != null) {
                entity.setSlug(command.getSlug());
            }
            if (command.getMediumType() != null) {
                entity.setMediumType(command.getMediumType());
            }
            entity.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
            this.menuRepository.update(entity);
        });
    }

    @Override
    public void dispatch(DeleteDataCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaMenuEntity entity = (MetaMenuEntity)this.menuRepository.getById(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u83dc\u5355\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            this.menuRepository.delete(command.getId());
        });
    }

    @Override
    public EntityCollection<MetaMenuEntity> search(MetaMenuSearchCriteria criteria) {
        return this.menuRepository.search(criteria);
    }

    @Override
    public MetaMenuEntity getById(String id) {
        return (MetaMenuEntity)this.menuRepository.getById(id);
    }
}

