package com.bcxin.tenant.bcx.jdks.responses.metas;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import lombok.Getter;

import java.sql.Timestamp;

@Getter
public class ProjectMetaResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String note;
    private final boolean enabled;
    private final String logo;
    private final String slug;
    
    // 新增创建者追踪字段
    private final MetaCreatorReferenceType referenceType;
    private final String referenceNumber;
    private final String creatorId;
    private final String lastUpdatorId;
    
    private final Timestamp createdTime;
    private final Timestamp lastUpdatedTime;

    public ProjectMetaResponse(String id, String name, String note, boolean enabled, String logo, String slug,
                              MetaCreatorReferenceType referenceType, String referenceNumber, 
                              String creatorId, String lastUpdatorId,
                              Timestamp createdTime, Timestamp lastUpdatedTime) {
        this.id = id;
        this.name = name;
        this.note = note;
        this.enabled = enabled;
        this.logo = logo;
        this.slug = slug;
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.creatorId = creatorId;
        this.lastUpdatorId = lastUpdatorId;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public static ProjectMetaResponse from(String id, String name, String note, boolean enabled, String logo, String slug,
                                          MetaCreatorReferenceType referenceType, String referenceNumber,
                                          String creatorId, String lastUpdatorId,
                                          Timestamp createdTime, Timestamp lastUpdatedTime) {
        return new ProjectMetaResponse(id, name, note, enabled, logo, slug, 
                                       referenceType, referenceNumber, creatorId, lastUpdatorId,
                                       createdTime, lastUpdatedTime);
    }
}
