package com.bcxin.tenant.bcx.jdks.responses.metas;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.snapshots.metas.*;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Map;

@Schema(name = "PageSettingResponse", title = "页面设置配置")
@Getter
public class PageSettingResponse extends ResponseAbstract {
    @Schema(name = "variables", title = "可用的表单变量",
            description = "分为三部分: 1、系统级变量; 2、会话级变量; 3、租户级变量")
    private final Map<String, MetaPageVariableSnapshot> variables;

    @Schema(name = "fields", title = "可用的系统字段(区分页面)",
            description = "分为三部分: 1、基础控件(行业/机构信息); 2、租户控件(用户/部门控件); 3、管理控件(主管/监管控件)")
    private final Map<String,MetaPageFieldSnapshot> fields;

    private final Map<String,MetaPageGlobalClassSnapshot> classes;

    private final Map<String,MetaPageGlobalEventSnapshot> events;

    private final Map<String,MetaPageGlobalSettingSnapshot> settings;



    public PageSettingResponse(Map<String, MetaPageVariableSnapshot> variables, Map<String, MetaPageFieldSnapshot> fields, Map<String, MetaPageGlobalClassSnapshot> classes, Map<String, MetaPageGlobalEventSnapshot> events, Map<String, MetaPageGlobalSettingSnapshot> settings) {
        this.variables = variables;
        this.fields = fields;
        this.classes = classes;
        this.events = events;
        this.settings = settings;
    }
}
