package com.bcxin.tenant.bcx.jdks.responses.metas;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Getter;

import java.sql.Timestamp;

/**
 * 页面元数据响应
 */
@Getter
public class PageMetaResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String note;
    private final String projectId;
    private final String projectName;
    private final String moduleId;
    private final String moduleName;
    private final String slug;
    private final String logo;
    private final PageType pageType;
    private final long version;
    private final String formJson;
    private final PageBusinessType businessType;
    private final String businessTypeName;
    private final String tableName;
    private final boolean enableBPMFlow;
    private final MetaCreatorReferenceType referenceType;
    private final String referenceNumber;
    private final String creatorId;
    private final String lastUpdatorId;
    private final Timestamp createdTime;
    private final Timestamp lastUpdatedTime;

    public PageMetaResponse(String id, String name, String note, String projectId, String projectName,
                           String moduleId, String moduleName, String slug, String logo, PageType pageType, long version,
                           String formJson, PageBusinessType businessType, String businessTypeName, String tableName,
                           boolean enableBPMFlow, MetaCreatorReferenceType referenceType, String referenceNumber,
                           String creatorId, String lastUpdatorId, Timestamp createdTime, Timestamp lastUpdatedTime) {
        this.id = id;
        this.name = name;
        this.note = note;
        this.projectId = projectId;
        this.projectName = projectName;
        this.moduleId = moduleId;
        this.moduleName = moduleName;
        this.slug = slug;
        this.logo = logo;
        this.pageType = pageType;
        this.version = version;
        this.formJson = formJson;
        this.businessType = businessType;
        this.businessTypeName = businessTypeName;
        this.tableName = tableName;
        this.enableBPMFlow = enableBPMFlow;
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.creatorId = creatorId;
        this.lastUpdatorId = lastUpdatorId;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public static PageMetaResponse from(String id, String name, String note, String projectId, String projectName,
                                       String moduleId, String moduleName, String slug, String logo, PageType pageType, long version,
                                       String formJson, PageBusinessType businessType, String businessTypeName, String tableName,
                                       boolean enableBPMFlow, MetaCreatorReferenceType referenceType, String referenceNumber,
                                       String creatorId, String lastUpdatorId, Timestamp createdTime, Timestamp lastUpdatedTime) {
        return new PageMetaResponse(id, name, note, projectId, projectName, moduleId, moduleName, slug, logo,
                pageType, version, formJson, businessType, businessTypeName, tableName, enableBPMFlow,
                referenceType, referenceNumber, creatorId, lastUpdatorId, createdTime, lastUpdatedTime);
    }
}

