package com.bcxin.tenant.bcx.jdks.responses.metas;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import lombok.Getter;

import java.sql.Timestamp;

/**
 * 模块元数据响应
 */
@Getter
public class ModuleMetaResponse extends ResponseAbstract {
    private final String id;
    private final String projectId;
    private final String projectName;
    private final String name;
    private final MetaCreatorReferenceType referenceType;
    private final String referenceNumber;
    private final String creatorId;
    private final String lastUpdatorId;
    private final Timestamp createdTime;
    private final Timestamp lastUpdatedTime;

    public ModuleMetaResponse(String id, String projectId, String projectName, String name,
                              MetaCreatorReferenceType referenceType, String referenceNumber,
                              String creatorId, String lastUpdatorId,
                              Timestamp createdTime, Timestamp lastUpdatedTime) {
        this.id = id;
        this.projectId = projectId;
        this.projectName = projectName;
        this.name = name;
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.creatorId = creatorId;
        this.lastUpdatorId = lastUpdatorId;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public static ModuleMetaResponse from(String id, String projectId, String projectName, String name,
                                          MetaCreatorReferenceType referenceType, String referenceNumber,
                                          String creatorId, String lastUpdatorId,
                                          Timestamp createdTime, Timestamp lastUpdatedTime) {
        return new ModuleMetaResponse(id, projectId, projectName, name, referenceType, referenceNumber,
                creatorId, lastUpdatorId, createdTime, lastUpdatedTime);
    }
}
