package com.bcxin.tenant.bcx.jdks.responses.commons;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.CommonSettingDataType;
import lombok.Data;

@Data
public class CommonSettingResponse extends ResponseAbstract {
    private String code;
    private CommonSettingDataType dataType;

    private String name;
    private String note;

    public CommonSettingResponse(){}

    public CommonSettingResponse(String code, CommonSettingDataType dataType, String name, String note) {
        this.code = code;
        this.dataType = dataType;
        this.name = name;
        this.note = note;
    }

    public static CommonSettingResponse create(String code, CommonSettingDataType dataType, String name, String note) {
        return new CommonSettingResponse(code, dataType, name,note);
    }
}
