package com.bcxin.tenant.bcx.jdks.requests.metas;

import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.jdks.requests.RequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class ProjectMetaRequest extends RequestAbstract {
    @Schema(name = "id", title = "主键", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true )
    private String id;

    @Schema(name = "name", title = "项目名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private String name;

    @Schema(name = "note", title = "备注", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String note;

    @Schema(name = "enabled", title = "是否启用", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private boolean enabled;

    @Schema(name = "logo", title = "项目Logo URL", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String logo;

    @Schema(name = "slug", title = "项目标识符", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String slug;

    // ============ 新增创建者追踪字段 ============
    @Schema(name = "referenceType", title = "创造者类型: Platform-平台, Tenant-租户, User-用户", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private MetaCreatorReferenceType referenceType;

    @Schema(name = "referenceNumber", title = "创建者标识(平台组织Id/租户Id/用户Id)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String referenceNumber;

    @Schema(name = "creatorId", title = "创作者Id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String creatorId;

    @Schema(name = "lastUpdatorId", title = "最后修改人Id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String lastUpdatorId;
    // ============================================
}
