package com.bcxin.tenant.bcx.jdks.requests.metas;

import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import com.bcxin.tenant.bcx.jdks.requests.SearchRequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 页面元数据搜索请求
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class PageMetaSearchRequest extends SearchRequestAbstract {
    @Schema(name = "id", title = "主键", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true)
    private String id;

    @Schema(name = "ids", title = "主键列表", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true)
    private List<String> ids;

    @Schema(name = "projectId", title = "项目ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String projectId;

    @Schema(name = "moduleId", title = "模块ID", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String moduleId;

    @Schema(name = "name", title = "页面名称", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String name;

    @Schema(name = "slug", title = "页面标识", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String slug;

    @Schema(name = "pageType", title = "页面类型", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "支持单个或多个页面类型搜索")
    private PageType pageType;

    @Schema(name = "pageTypes", title = "页面类型列表", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "多选页面类型")
    private List<PageType> pageTypes;

    @Schema(name = "businessType", title = "业务类型", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "支持单个或多个业务类型搜索")
    private PageBusinessType businessType;

    @Schema(name = "businessTypes", title = "业务类型列表", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "多选业务类型")
    private List<PageBusinessType> businessTypes;

    @Schema(name = "tableName", title = "数据库-表名", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String tableName;

    @Schema(name = "enableBPMFlow", title = "是否启用流程", requiredMode = Schema.RequiredMode.NOT_REQUIRED, defaultValue = "false")
    private Boolean enableBPMFlow;

}

