package com.bcxin.tenant.bcx.jdks.requests.metas;

import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.jdks.requests.RequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = false)
public class ModuleMetaRequest extends RequestAbstract {
    @Schema(name = "projectId", title = "项目Id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String projectId;

    @Schema(name = "name", title = "模块名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private String name;

    @Schema(name = "referenceType", title = "创造者类型", description = "Platform=平台, Tenant=租户, User=用户")
    private MetaCreatorReferenceType referenceType;

    @Schema(name = "referenceNumber", title = "创建者标识", description = "平台组织Id/租户Id/用户Id")
    private String referenceNumber;

    @Schema(name = "creatorId", title = "创作者Id")
    private String creatorId;

    @Schema(name = "lastUpdatorId", title = "最后修改人Id")
    private String lastUpdatorId;
}
