package com.bcxin.tenant.bcx.jdks.requests.enums;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(name = "ResourceType",title = "人员/驻勤点的资源类型")
public enum EmployeeResourceType {
    @Schema(name = "Security", title = "保安员")
    Security {
        @Override
        public String getTypeName() {
            return "保安员";
        }
    },

    @Schema(name = "Population", title = "社会力量")
    Population {
        @Override
        public String getTypeName() {
            return "社会力量";
        }
    },

    @Schema(name = "ProfessionalPopulation", title = "全职社会力量")
    ProfessionalPopulation {
        @Override
        public String getTypeName() {
            return "全职社会力量";
        }
    },

    /**
     * 内保单位的数据: 比如: 甲方管理员
     */
    @Schema(name = "Proprietor", title = "内保单位-甲方管理员")
    Proprietor {
        @Override
        public String getTypeName() {
            return "甲方管理员";
        }
    },

    /**
     * 内保单位管理的数据: 比如: 所关联的保安员和驻勤点
     */
    @Schema(name = "ProprietorManaged", title = "内保单位管理的保安员")
    ProprietorManaged {
        @Override
        public String getTypeName() {
            return "内保单位管理的保安员";
        }
    },

    @Schema(name = "TemporarySecurity", title = "临保业务")
    TemporarySecurity{
        @Override
        public String getTypeName() {
            return "临保业务";
        }
    };

    public abstract String getTypeName();
}