package com.bcxin.tenant.bcx.jdks;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.jdks.requests.metas.PageMetaRequest;
import com.bcxin.tenant.bcx.jdks.requests.metas.PageMetaSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.metas.PageMetaResponse;

import java.util.List;

/**
 * 页面元数据RPC提供者接口
 */
public interface PageMetaRpcProvider {
    /**
     * 创建页面
     */
    void create(PageMetaRequest request);

    /**
     * 更新页面
     */
    void update(String id, PageMetaRequest request);

    /**
     * 删除页面
     */
    void delete(String id);

    /**
     * 批量删除页面（逻辑删除）
     */
    void batchDelete(List<String> ids);

    /**
     * 搜索页面
     */
    EntityCollection<PageMetaResponse> search(PageMetaSearchRequest request);

    /**
     * 根据ID获取页面
     */
    PageMetaResponse getById(String id);
}
