package com.bcxin.tenant.bcx.jdks;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.jdks.requests.metas.ModuleMetaRequest;
import com.bcxin.tenant.bcx.jdks.requests.metas.ModuleMetaSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.metas.ModuleMetaResponse;

import java.util.List;

/**
 * 模块元数据RPC提供者接口
 */
public interface ModuleMetaRpcProvider {
    /**
     * 创建模块
     */
    void create(ModuleMetaRequest request);

    /**
     * 更新模块
     */
    void update(String id, ModuleMetaRequest request);

    /**
     * 删除模块
     */
    void delete(String id);

    /**
     * 批量删除模块（逻辑删除）
     */
    void batchDelete(List<String> ids);

    /**
     * 搜索模块
     */
    EntityCollection<ModuleMetaResponse> search(ModuleMetaSearchRequest request);

    /**
     * 根据ID获取模块
     */
    ModuleMetaResponse getById(String id);
}
