package com.bcxin.tenant.bcx.infrastructures.snapshots.metas;

import com.bcxin.tenant.bcx.infrastructures.snapshots.SnapshotAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.Map;

@Schema(name = "系统字段", title = "可用的系统字段(区分页面)",
        description = "分为三部分: 1、基础控件(行业/机构信息); 2、租户控件(用户/部门控件); 3、管理控件(主管/监管控件)")
@Data
public class MetaPageFieldSnapshot extends SnapshotAbstract {
    private String label;
    private String type;
    private String parse;
    private String beforeFetch;
    private String onError;
    private String action;
    private String method;
    private String dataType;
    private Map headers;
    private Map query;
    private Collection data;
    private boolean deletable;
}
