package com.bcxin.tenant.bcx.infrastructures.models;

import lombok.Data;

import java.io.Serializable;
import java.util.Collection;

@Data
public class UserPermissionModel implements Serializable {
    private String tenantUserId;
    private String employeeId;
    private String organizationId;

    private Collection<GrantedOrganDepartModel> permissionData;

    public void assign(Collection<GrantedOrganDepartModel> permissionData) {
        this.setPermissionData(permissionData);
    }

    public static UserPermissionModel create(String tenantUserId, String employeeId,
                                             String organizationId) {
        UserPermissionModel model = new UserPermissionModel();
        model.setTenantUserId(tenantUserId);
        model.setEmployeeId(employeeId);
        model.setOrganizationId(organizationId);

        return model;
    }
}
