/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.infrastructures.models;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;

public class CacheData<T>
implements Serializable {
    private final T data;
    private final Timestamp createdTime;
    private final Timestamp expiredTime;
    private final int expiredInSeconds;

    public CacheData(T data, int expiredInSeconds) {
        this.data = data;
        this.createdTime = Timestamp.from(Instant.now());
        this.expiredInSeconds = expiredInSeconds;
        this.expiredTime = Timestamp.from(Instant.now().plusMillis(expiredInSeconds * 1000));
    }

    public boolean IsExpired() {
        Timestamp now = Timestamp.from(Instant.now());
        return now.after(this.getExpiredTime());
    }

    public static <T> CacheData create(T data, int expiredInSeconds) {
        return new CacheData<T>(data, expiredInSeconds);
    }

    public T getData() {
        return this.data;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getExpiredTime() {
        return this.expiredTime;
    }

    public int getExpiredInSeconds() {
        return this.expiredInSeconds;
    }
}

