/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.MetaModuleEntity;
import com.bcxin.tenant.bcx.domains.entities.MetaProjectEntity;
import com.bcxin.tenant.bcx.domains.repositories.MetaModuleRepository;
import com.bcxin.tenant.bcx.domains.repositories.MetaProjectRepository;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaModuleSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.MetaProjectService;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.projects.BatchLogicalDeleteProjectCommand;
import com.bcxin.tenant.bcx.domains.services.commands.projects.CreateMetaProjectCommand;
import com.bcxin.tenant.bcx.domains.services.commands.projects.LogicalDeleteProjectCommand;
import com.bcxin.tenant.bcx.domains.services.commands.projects.UpdateMetaProjectCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import org.springframework.stereotype.Service;

@Service
public class MetaProjectServiceImpl
implements MetaProjectService {
    private final MetaProjectRepository metaProjectRepository;
    private final MetaModuleRepository metaModuleRepository;
    private final UnitWork unitWork;
    private final IdWorker idWorker;

    public MetaProjectServiceImpl(MetaProjectRepository metaProjectRepository, MetaModuleRepository metaModuleRepository, UnitWork unitWork, IdWorker idWorker) {
        this.metaProjectRepository = metaProjectRepository;
        this.metaModuleRepository = metaModuleRepository;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreateMetaProjectCommand command) {
        command.validate();
        if (StringUtil.isEmpty((String)command.getName())) {
            throw new IllegalArgumentException("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.unitWork.executeTran(() -> {
            String id = command.getId();
            if (StringUtil.isEmpty((String)command.getId())) {
                id = String.valueOf(this.idWorker.getNextId());
            }
            MetaProjectEntity entity = MetaProjectEntity.create(id, command.getName(), command.getNote(), command.isEnabled(), command.getLogo(), command.getSlug(), command.getReferenceType(), command.getReferenceNumber(), command.getCreatorId());
            this.metaProjectRepository.insert(entity);
        });
    }

    @Override
    public void dispatch(UpdateMetaProjectCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaProjectEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u9879\u76ee\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u66f4\u65b0\u5df2\u5220\u9664\u7684\u9879\u76ee\uff0cID: " + command.getId());
            }
            entity.change(command.getName(), command.getNote(), command.isEnabled(), command.getLogo(), command.getSlug(), command.getLastUpdatorId());
            this.metaProjectRepository.update(entity);
        });
    }

    @Override
    public void dispatch(DeleteDataCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaProjectEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u9879\u76ee\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u5220\u9664\u5df2\u5220\u9664\u7684\u9879\u76ee\uff0cID: " + command.getId());
            }
            MetaModuleSearchCriteria criteria = MetaModuleSearchCriteria.create(null, null, command.getId(), null, 1, 1);
            EntityCollection<MetaModuleEntity> modules = this.metaModuleRepository.search(criteria);
            if (modules.getTotalCount() > 0L) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u5220\u9664\u9879\u76ee\uff0c\u8be5\u9879\u76ee\u4e0b\u8fd8\u6709 " + modules.getTotalCount() + " \u4e2a\u6a21\u5757\uff0c\u8bf7\u5148\u5220\u9664\u6240\u6709\u6a21\u5757");
            }
            this.metaProjectRepository.delete(command.getId());
        });
    }

    @Override
    public void dispatch(LogicalDeleteProjectCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaProjectEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u9879\u76ee\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u9879\u76ee\u5df2\u88ab\u5220\u9664\uff0cID: " + command.getId());
            }
            entity.markAsDeleted();
            this.metaProjectRepository.update(entity);
        });
    }

    @Override
    public void dispatch(BatchLogicalDeleteProjectCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            for (String id : command.getIds()) {
                MetaProjectEntity entity = this.getByIdIncludeDeleted(id);
                if (entity == null) {
                    throw new IllegalArgumentException("\u9879\u76ee\u4e0d\u5b58\u5728\uff0cID: " + id);
                }
                if (entity.isDeleted()) {
                    throw new IllegalArgumentException("\u9879\u76ee\u5df2\u88ab\u5220\u9664\uff0cID: " + id);
                }
                entity.markAsDeleted();
                this.metaProjectRepository.update(entity);
            }
        });
    }

    @Override
    public EntityCollection<MetaProjectEntity> search(int pageIndex, int pageSize) {
        return this.metaProjectRepository.search(pageIndex, pageSize);
    }

    @Override
    public MetaProjectEntity getById(String id) {
        MetaProjectEntity entity = (MetaProjectEntity)this.metaProjectRepository.getById(id);
        if (entity != null && entity.isDeleted()) {
            return null;
        }
        return entity;
    }

    private MetaProjectEntity getByIdIncludeDeleted(String id) {
        return (MetaProjectEntity)this.metaProjectRepository.getById(id);
    }
}

