/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.MetaModuleEntity;
import com.bcxin.tenant.bcx.domains.repositories.MetaModuleRepository;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaModuleSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.MetaModuleService;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.BatchLogicalDeleteModuleCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.CreateMetaModuleCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.LogicalDeleteModuleCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.UpdateMetaModuleCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import java.sql.Timestamp;
import org.springframework.stereotype.Service;

@Service
public class MetaModuleServiceImpl
implements MetaModuleService {
    private final MetaModuleRepository metaModuleRepository;
    private final UnitWork unitWork;
    private final IdWorker idWorker;

    public MetaModuleServiceImpl(MetaModuleRepository metaModuleRepository, UnitWork unitWork, IdWorker idWorker) {
        this.metaModuleRepository = metaModuleRepository;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreateMetaModuleCommand command) {
        command.validate();
        if (StringUtil.isEmpty((String)command.getName())) {
            throw new IllegalArgumentException("\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.unitWork.executeTran(() -> {
            String id = String.valueOf(this.idWorker.getNextId());
            MetaModuleEntity entity = MetaModuleEntity.create(id, command.getProjectId(), command.getName(), command.getReferenceType(), command.getReferenceNumber(), command.getCreatorId());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            entity.setCreatedTime(now);
            entity.setLastUpdatedTime(now);
            this.metaModuleRepository.insert(entity);
        });
    }

    @Override
    public void dispatch(UpdateMetaModuleCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaModuleEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u6a21\u5757\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u66f4\u65b0\u5df2\u5220\u9664\u7684\u6a21\u5757\uff0cID: " + command.getId());
            }
            entity.change(command.getName(), command.getLastUpdatorId());
            entity.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
            this.metaModuleRepository.update(entity);
        });
    }

    @Override
    public void dispatch(DeleteDataCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaModuleEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u6a21\u5757\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u5220\u9664\u5df2\u5220\u9664\u7684\u6a21\u5757\uff0cID: " + command.getId());
            }
            this.metaModuleRepository.delete(command.getId());
        });
    }

    @Override
    public void dispatch(LogicalDeleteModuleCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaModuleEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new IllegalArgumentException("\u6a21\u5757\u4e0d\u5b58\u5728\uff0cID: " + command.getId());
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u6a21\u5757\u5df2\u88ab\u5220\u9664\uff0cID: " + command.getId());
            }
            entity.markAsDeleted();
            entity.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
            this.metaModuleRepository.update(entity);
        });
    }

    @Override
    public void dispatch(BatchLogicalDeleteModuleCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            for (String id : command.getIds()) {
                MetaModuleEntity entity = this.getByIdIncludeDeleted(id);
                if (entity == null) {
                    throw new IllegalArgumentException("\u6a21\u5757\u4e0d\u5b58\u5728\uff0cID: " + id);
                }
                if (entity.isDeleted()) {
                    throw new IllegalArgumentException("\u6a21\u5757\u5df2\u88ab\u5220\u9664\uff0cID: " + id);
                }
                entity.markAsDeleted();
                entity.setLastUpdatedTime(now);
                this.metaModuleRepository.update(entity);
            }
        });
    }

    @Override
    public EntityCollection<MetaModuleEntity> search(MetaModuleSearchCriteria criteria) {
        return this.metaModuleRepository.search(criteria);
    }

    @Override
    public MetaModuleEntity getById(String id) {
        MetaModuleEntity entity = (MetaModuleEntity)this.metaModuleRepository.getById(id);
        if (entity != null && entity.isDeleted()) {
            return null;
        }
        return entity;
    }

    private MetaModuleEntity getByIdIncludeDeleted(String id) {
        return (MetaModuleEntity)this.metaModuleRepository.getById(id);
    }
}

