package com.bcxin.tenant.bcx.jdks.requests.metas;

import com.bcxin.tenant.bcx.jdks.requests.SearchRequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

@Data
public class ProjectMetaSearchRequest extends SearchRequestAbstract {
    @Schema(name = "id", title = "主键", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true )
    private String id;

    @Schema(name = "ids", title = "主键列表", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true )
    private List<String> ids;

    @Schema(name = "name", title = "项目名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private String name;

    @Schema(name = "note", title = "备注", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String note;

    @Schema(name = "enabled", title = "是否启用", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private Boolean enabled;

    @Schema(name = "slug", title = "项目标识符", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String slug;
}
