package com.bcxin.tenant.bcx.jdks.requests.metas;

import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import com.bcxin.tenant.bcx.jdks.requests.RequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.sql.Timestamp;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
public class PageMetaRequest extends RequestAbstract {

    @Schema(name = "moduleId", title = "模块Id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String moduleId;

    @Schema(name = "name", title = "表单名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private String name;

    @Schema(name = "note", title = "备注", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String note;

    @Schema(name = "formJson", title = "结构", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String formJson;

    @Schema(name = "slug", title = "页面的url地址;未填的时候;系统自动生成", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String slug;

    @Schema(name = "logo", title = "logo", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String logo;

    @Schema(name = "pageType", title = "页面类型", requiredMode = Schema.RequiredMode.REQUIRED)
    private PageType pageType;

    @Schema(name = "businessType", title = "业务类型", requiredMode = Schema.RequiredMode.REQUIRED)
    private PageBusinessType businessType;

    @Schema(name = "tableName", title = "数据库-表名", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String tableName;

    @Schema(name = "enableBPMFlow", title = "是否启用流程", requiredMode = Schema.RequiredMode.NOT_REQUIRED, defaultValue = "false")
    private boolean enableBPMFlow;

    @Schema(name = "enableAnonymousAccess", title = "是否启用匿名访问", requiredMode = Schema.RequiredMode.NOT_REQUIRED, defaultValue = "false")
    private boolean enableAnonymousAccess;

    @Schema(name = "settingJson", title = "表单扩展设置, 过滤设置, 列表展示设置", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String settingJson;

    @Schema(name = "beginTime", title = "开始时间", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private Timestamp beginTime;

    @Schema(name = "endTime", title = "结束时间", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private Timestamp endTime;
}
