package com.bcxin.tenant.bcx.jdks.requests.metas;

import com.bcxin.tenant.bcx.jdks.requests.SearchRequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 菜单元数据搜索请求
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MenuMetaSearchRequest extends SearchRequestAbstract {
    @Schema(name = "id", title = "主键", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true)
    private String id;

    @Schema(name = "ids", title = "主键列表", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true)
    private List<String> ids;

    @Schema(name = "projectId", title = "项目ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String projectId;

    @Schema(name = "name", title = "菜单名称", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String name;

    @Schema(name = "pageId", title = "页面ID", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String pageId;

    @Schema(name = "parentId", title = "上级菜单ID", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String parentId;

    @Schema(name = "mediumType", title = "适配设备类型", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private Integer mediumType;
}
